$(function() {


    // This function gets cookie with a given name
    function getCookie(name) {
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
    var csrftoken = getCookie('csrftoken');

    /*
    The functions below will create a header with csrftoken
    */

    function csrfSafeMethod(method) {
        // these HTTP methods do not require CSRF protection
        return (/^(GET|HEAD|OPTIONS|TRACE)$/.test(method));
    }
    function sameOrigin(url) {
        // test that a given url is a same-origin URL
        // url could be relative or scheme relative or absolute
        var host = document.location.host; // host + port
        var protocol = document.location.protocol;
        var sr_origin = '//' + host;
        var origin = protocol + sr_origin;
        // Allow absolute or scheme relative URLs to same origin
        return (url == origin || url.slice(0, origin.length + 1) == origin + '/') ||
            (url == sr_origin || url.slice(0, sr_origin.length + 1) == sr_origin + '/') ||
            // or any other URL that isn't scheme relative or absolute i.e relative.
            !(/^(\/\/|http:|https:).*/.test(url));
    }

    $.ajaxSetup({
        beforeSend: function(xhr, settings) {
            if (!csrfSafeMethod(settings.type) && sameOrigin(settings.url)) {
                // Send the token to same-origin, relative URLs only.
                // Send the token only if the method warrants CSRF protection
                // Using the CSRFToken value acquired earlier
                xhr.setRequestHeader("X-CSRFToken", csrftoken);
            }
        }
    });

});

// Submit post on submit
$('.basket-form').submit(function(event){
    event.preventDefault();
    event.stopPropagation();
    console.log("form just submitted! serializing data");  // sanity check
    var serializedData = $(this).serialize();

    console.log(serializedData);
    $.ajax({
            type: 'POST',
            url: "/add_basket",

            data: serializedData,

            success: function (response) {
                // on successfull add to basket
                // update the basket
                console.log("action completed successfully");
                var instance = JSON.parse(response["instance"]);
                var description = response["description"];
                console.log(description);
                document.getElementById("bqty").innerHTML = instance;
                document.getElementById("bqty2").innerHTML = instance;
                document.getElementById('modal-box-text').innerHTML = description;
                var mydiv = document.getElementById('modal-box');
                mydiv.style.display = '';
                setTimeout(closeModal, 3000)

                $('.basket-form').trigger('reset');
            },

            error: function (response) {
                // alert the error if any error occured
                 console.log("action failed");
                //alert(response["responseJSON"]["error"]);
                location.reload();
            }
        })
});
